#include<iostream>
#include<cstdio>
#include<cstdlib>
#include "Stack.cpp"
#include "Queue.cpp"

using namespace std;

template<typename Front, typename Visitor>
void fs(bool ** , int, int);
void dfs(bool **, int, int);
void bfs(bool **, int, int);

class CoutVisitor
{
public:
	void visitVertex(int vertex) {
		cout << vertex << ' ';
	}
};

int main()
{
	freopen("in.txt", "r", stdin);
	
	int count;
	cin >> count;
	bool ** am = new bool*[count];
	for (int i = 0; i < count; ++i)
	{
		am[i] = new bool[count];
		for (int j = 0; j < count; ++j)
		{
			am[i][j] = false;
		}
	}

	int edges_count;
	cin >> edges_count;

	for (int i = 0; i < edges_count; ++i)
	{
		int a, b;
		cin >> a >> b;
		a -= 1;
		b -= 1;
		am[a][b] = am[b][a] = true;
	}

	dfs(am, 1, count);
	cout << endl;
	bfs(am, 1, count);
	cout << endl;

	for (int i = 0; i < count; ++i)
	{
		delete[] am[i];
	}
	delete[] am;

	return 0;
}

void dfs(bool ** am, int start, int count)
{
	fs<Stack<int>, CoutVisitor>(am, start, count);
}


void bfs(bool ** am, int start, int count)
{
	fs<Queue<int>, CoutVisitor>(am, start, count);
}

template<typename Front, typename Visitor>
void fs(bool ** am, int start, int count)
{
	start -= 1;

	bool * vis = new bool[count];
	for ( int i = 0; i < count; ++i)
	{
		vis[i] = false;
	}
	Front s;
	Visitor v;

	vis[start] = true;
	s.push(start);

	while( !s.isEmpty() )
	{
		int cur = s.peek();
		s.pop();
		v.visitVertex(cur+1);
		
		for ( int i = 0; i < count; ++i)
		{
			if (am[cur][i] && !vis[i] )
			{
				s.push(i);
				vis[i] = true;
			}
		}

	}

	delete[] vis;
}